<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h3 class="head-title"><i class="fa fa-bar-chart"></i><small> <?php echo 'Broadsheet'; ?></small></h3>
                <ul class="nav navbar-right panel_toolbox">
                    <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>
                </ul>
                <div class="clearfix"></div>
            </div>

            <?php $this->load->view('quick_report'); ?>

            <div class="x_content filter-box no-print">
                <?php echo form_open_multipart(site_url('report/examresult'), array('name' => 'examresult', 'id' => 'examresult', 'class' => 'form-horizontal form-label-left'), ''); ?>
                <div class="row">

                    <?php $this->load->view('layout/school_list_filter'); ?>
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group">
                            <div><?php echo $this->lang->line('academic_year'); ?> <span class="red">*</span></div>
                            <select class="form-control col-md-7 col-xs-12" name="academic_year_id" required
                                id="academic_year_id">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($academic_years as $obj) { ?>
                                <?php $running = $obj->is_running ? ' [' . $this->lang->line('running_year') . ']' : ''; ?>
                                <option value="<?php echo $obj->id; ?>" <?php if (isset($academic_year_id) && $academic_year_id == $obj->id) {
                                                                                echo 'selected="selected"';
                                                                            } ?>>
                                    <?php echo $obj->session_year;
                                                                                                                                                                                    echo $running; ?>
                                </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group">
                            <div><?php echo $this->lang->line('exam'); ?> <span class="required">*</span></div>
                            <select class="form-control col-md-7 col-xs-12" name="exam_id" id="exam_id"
                                required="required">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($exams as $obw) { ?>
                                <option value="<?php echo $obj->id; ?>"
                                    <?php if(isset($exam_id) && $exam_id == $obw->id){ echo 'selected="selected"';} ?>>
                                    <?php echo $obw->title; ?></option>
                                <?php } ?>
                            </select>
                            <div class="help-block"><?php echo form_error('exam_id'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group">
                            <div><?php echo $this->lang->line('class'); ?> <span class="red">*</span></div>
                            <select class="form-control col-md-7 col-xs-12" name="class_id" id="class_id" required
                                onchange="get_section_by_class('',this.value, '');">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($classes as $obj) { ?>
                                <option value="<?php echo $obj->id; ?>" <?php if (isset($class_id) && $class_id == $obj->id) {
                                                                                echo 'selected="selected"';
                                                                            } ?>><?php echo $obj->name; ?></option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>
                    <div class="col-md-1 col-sm-1 col-xs-6">
                        <div class="item form-group">
                            <div><?php echo $this->lang->line('section'); ?></div>
                            <select class="form-control col-md-7 col-xs-12" name="section_id" id="section_id">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                            </select>
                        </div>
                    </div>

                    <div class="col-md-1 col-sm-1 col-xs-6">
                        <div class="form-group"><br />
                            <button id="send" type="submit"
                                class="btn btn-success"><?php echo $this->lang->line('find'); ?></button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>

            <div class="x_content">
                <div class="" data-example-id="togglable-tabs">

                    <?php if (isset($school) && !empty($school)) { ?>
                    <div class="x_content">
                        <div class="row">
                            <div class="col-sm-3 col-xs-3">&nbsp;</div>
                            <div class="col-sm-6  col-xs-6 layout-box">
                                <div>
                                    <?php if ($school->logo) { ?>
                                    <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $school->logo; ?>" alt="" />
                                    <?php } else if ($school->frontend_logo) { ?>
                                    <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $school->frontend_logo; ?>"
                                        alt="" />
                                    <?php } else { ?>
                                    <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $this->global_setting->brand_logo; ?>"
                                        alt="" />
                                    <?php } ?>
                                    <h4><?php echo $school->school_name; ?></h4>
                                    <div><?php echo $school->address; ?></div>
                                    <h3 class="head-title ptint-title" style="width: 100%;"><i
                                            class="fa fa-bar-chart"></i><small> <?php echo 'Broadsheet'; ?></small></h3>
                                    <div class="clearfix">&nbsp;</div>
                                    <?php if (isset($academic_year)) { ?>
                                    <div><?php echo $this->lang->line('academic_year'); ?>:
                                        <?php echo $academic_year; ?></div>
                                    <?php } ?>
                                    <div>
                                        <?php if (isset($class)) { ?>
                                        <?php echo $this->lang->line('class'); ?>: <?php echo $class; ?>
                                        <?php } ?>
                                        <?php if (isset($section)) { ?>
                                        , <?php echo $this->lang->line('section'); ?>: <?php echo $section; ?>
                                        <?php } ?>
                                    </div>
                                    <div class="clearfix">&nbsp;</div>
                                </div>
                            </div>
                            <div class="col-sm-3  col-xs-3">&nbsp;</div>
                        </div>
                    </div>
                    <?php } ?>

                    <ul class="nav nav-tabs bordered no-print">
                        <li class="active"><a href="#tab_tabular" role="tab" data-toggle="tab" aria-expanded="true"><i
                                    class="fa fa-list-ol"></i> <?php echo $this->lang->line('tabular'); ?>
                                <?php echo $this->lang->line('report'); ?></a> </li>
                    </ul>
                    <br />

                    <div class="tab-content">
                        <div class="tab-pane fade in active" id="tab_tabular">
                            <div class="x_content">
                                <table id="datatable-keytable"
                                    class="datatable-responsive table table-striped table-bordered dt-responsive nowrap"
                                    cellspacing="0" width="100%">
                                    <thead>
                                        <tr style="font-size:10px">
                                            <th><?php echo $this->lang->line('name'); ?></th>
                                            <th><?php echo $this->lang->line('roll_no'); ?></th>
                                            <th><?php echo 'Total Subs'; ?></th>
                                            <?php
                                            $track = 0;
                                            $a = array();
                                            $b = array();
                                            if (isset($subjects) && !empty($subjects)) { ?>
                                            <?php foreach ($subjects as $obj) { ?>

                                            <?php
                                                    $a[$obj->sid] = $obj->code;
                                                    $track = $track + 1; ?>
                                            <?php }
                                                ksort($a);
                                                ?>
                                            <?php foreach ($a as $subj_id => $subj) { ?>
                                            <th><?php echo $subj; ?></th>
                                            <?php } ?>
                                            <?php } ?>
                                            <th><?php echo ""; ?></th>
                                            <th><?php echo ""; ?></th>
                                            <th><?php echo $this->lang->line('exam_mark'); ?></th>
                                            <th><?php echo $this->lang->line('obtain_mark'); ?></th>
                                            <th><?php echo "Average"; ?></th>
                                            <th><?php echo $this->lang->line('letter_grade'); ?></th>
                                            <th><?php echo 'Section Position'; ?></th>
                                            <th><?php echo 'Class Position'; ?></th>

                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php
                                        $sentinel = $track - 2;
                                      
                                        if (isset($examresult) && !empty($examresult)) {

                                            foreach ($examresult as $obj) { ?>
                                        <?php if ($obj->total_subject != 0) { ?>
                                         <?php $class_position = get_student_position_broadsheet($school_id, $academic_year_id,$exam_id, $class_id, $obj->student_id); ?>
                                         <?php $section_position = get_student_position_broadsheet($school_id, $academic_year_id, $exam_id, $class_id, $obj->student_id, $obj->section_id); ?>
                                        
                                        <tr>
                                            <td><?php echo $obj->student; ?></td>
                                            <td><?php echo $obj->roll_no; ?></td>
                                            <td><?php echo $obj->total_subject; ?></td>
                                            <?php if (isset($exams) && !empty($exams)) {
                                                            $b = array();
                                                            $sn = 0; ?>
                                            <?php foreach ($exams as $ex) { ?>
                                            <?php
                                                                $exam_subjects = get_subject_list_report($school_id, $academic_year_id, $exam_id, $class_id, $obj->section_id, $obj->student_id);
                                                                $count = 0;
                                                                if (isset($exam_subjects) && !empty($exam_subjects)) { ?>

                                            <?php foreach ($exam_subjects as $obs) {
                                                                        $b[$obs->sidd] = $obs->obtain_total_mark;
                                                                    } ksort($b); 
                                                                    //$sn = 0;
                                                                $clean_array = array_values($b);
                                                                
                                                                    foreach ($a as $subz => $sub_id) { ?>

                                            <td> <?php
                                                                                if (array_key_exists($subz, $b)) {
                                                                                    if($sn >= count($clean_array)) {
                                                                                        break;
                                                                                    } elseif($sn < count($clean_array)) {
                                                                                        echo $clean_array[$sn];
                                                                                        $sn++;
                                                                                    }
                                                                                }else {
                                                                                    echo '-';
                                                                                }                                                                            
                                                                                 ?> </td>
                                            <?php 
                                                                        //} ?>

                                            <?php } ?>
                                            <?php } ?>
                                            <?php } ?>

                                             
                                            <td><?php echo $obj->total_mark; ?></td> 
                                            <td><?php echo str_replace(",", "", $obj->total_obtain_mark); ?></td>
                                             <td><?php echo @$obj->total_mark > 0 ? @number_format(str_replace(",", "", $obj->total_obtain_mark) / @$obj->total_mark * 100, 2) : 0; ?>%
                                            </td>
                                           
                                            <td><?php

                                                                @$percentage_score = @number_format(str_replace(",", "", $obj->total_obtain_mark) / @$obj->total_mark * 100, 2);

                                                                if ($percentage_score >= 80) {
                                                                    echo 'A1';
                                                                } elseif ($percentage_score >= 70 && $percentage_score < 80) {
                                                                    echo 'B2';
                                                                } elseif ($percentage_score >= 65 && $percentage_score < 70) {
                                                                    echo 'B3';
                                                                } elseif ($percentage_score >= 60 && $percentage_score < 65) {
                                                                    echo 'C4';
                                                                } elseif ($percentage_score >= 55 && $percentage_score < 60) {
                                                                    echo 'C5';
                                                                } elseif ($percentage_score >= 50 && $percentage_score < 55) {
                                                                    echo 'C6';
                                                                } elseif ($percentage_score >= 45 && $percentage_score < 50) {
                                                                    echo 'D7';
                                                                } elseif ($percentage_score >= 40 && $percentage_score < 45) {
                                                                    echo 'D8';
                                                                } elseif ($percentage_score < 40) {
                                                                    echo 'F9';
                                                                } else {
                                                                    echo '';
                                                                }; ?></td>

                                            
                                            <td><?php echo $section_position ?></td>
                                            <td><?php echo $class_position ?></td>

                                      

                                        </tr>
                                        <?php } ?>
                                        <?php } ?>
                                        <?php } ?>
                                        <?php } else { ?>
                                        <tr>
                                            <td colspan="12" class="text-center">
                                                <?php echo $this->lang->line('no_data_found'); ?></td>
                                        </tr>
                                        <?php } ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="row no-print">
                <div class="col-xs-12 text-right">
                    <button class="btn btn-default " onclick="window.print();"><i class="fa fa-print"></i>
                        <?php echo $this->lang->line('print'); ?></button>
                </div>
            </div>

        </div>
    </div>
</div>

<script type="text/javascript">
$("#examresult").validate();

$("document").ready(function() {
    <?php if (isset($school_id) && !empty($school_id)) { ?>
    $(".fn_school_id").trigger('change');
    <?php } ?>
});

$('.fn_school_id').on('change', function() {

    var school_id = $(this).val();
    var exam_id = '';
    var class_id = '';
    var section_id = '';
    var academic_year_id = '';

    <?php if (isset($school_id) && !empty($school_id)) { ?>
    exam_id = '<?php echo $exam_id; ?>';
    class_id = '<?php echo $class_id; ?>';
    section_id = '<?php echo $section_id; ?>';
    academic_year_id = '<?php echo $academic_year_id; ?>';
    <?php } ?>

    if (!school_id) {
        toastr.error('<?php echo $this->lang->line("select_school"); ?>');
        return false;
    }

    get_academic_year_by_school(school_id, academic_year_id);

    get_class_by_school(school_id, class_id, section_id);

});



function get_academic_year_by_school(school_id, academic_year_id) {

    $.ajax({
        type: "POST",
        url: "<?php echo site_url('ajax/get_academic_year_by_school'); ?>",
        data: {
            school_id: school_id,
            academic_year_id: academic_year_id
        },
        async: false,
        success: function(response) {
            if (response) {
                $('#academic_year_id').html(response);
                get_exam_by_academic_year(academic_year_id, school_id);
            }
        }
    });
}

function get_exam_by_academic_year(academic_year_id, school_id) {


    $.ajax({
        type: "POST",
        url: "<?php echo site_url('ajax/get_exam_id_by_academic_year'); ?>",
        data: {
            school_id: school_id,
            academic_year_id: academic_year_id
        },
        async: false,
        success: function(response) {
            if (response) {
                $('#exam_id').html(response);
            }
        }
    });
}

function get_class_by_school(school_id, class_id, section_id) {

    if (!school_id) {
        school_id = $('#school_id').val();
    }

    $.ajax({
        type: "POST",
        url: "<?php echo site_url('ajax/get_class_by_school'); ?>",
        data: {
            school_id: school_id,
            class_id: class_id
        },
        async: false,
        success: function(response) {
            if (response) {
                $('#class_id').html(response);
                get_section_by_class(school_id, class_id, section_id);
            }
        }
    });
}

function get_section_by_class(school_id, class_id, section_id) {

    if (!school_id) {
        school_id = $('#school_id').val();
    }

    $.ajax({
        type: "POST",
        url: "<?php echo site_url('ajax/get_section_by_class'); ?>",
        data: {
            school_id: school_id,
            class_id: class_id,
            section_id: section_id
        },
        async: false,
        success: function(response) {
            if (response) {
                $('#section_id').html(response);
            }
        }
    });
}
</script>