<!DOCTYPE html>
<html lang="en">
    <head>
        <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
        <!-- Meta, title, CSS, favicons, etc. -->
        <meta charset="utf-8">
        <meta charset="ISO-8859-15">
        <meta http-equiv="X-UA-Compatible" content="IE=edge">
        <!-- Mobile Specific Meta  -->
        <meta name="viewport" content="width=device-width, initial-scale=1, maximum-scale=1">

        <title><?php echo $title_for_layout; ?></title> 
        <meta name="viewport" content="width=device-width, initial-scale=1">
        <meta name="keywords" content="academy, college, coursera, courses, education, elearning, kindergarten, lms, lynda, online course, online education, school, training, udemy, university">
        <meta name="description" content="WePluz - School Management System">
        <?php if($this->global_setting->favicon_icon){ ?>
            <link rel="icon" href="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $this->global_setting->favicon_icon; ?>" type="image/x-icon" />             
        <?php }else{ ?>
            <link rel="icon" href="<?php echo IMG_URL; ?>favicon.ico" type="image/x-icon" />
        <?php } ?>
        
        <?php if(isset($school->theme_name)){ ?>            
            <?php $this->load->view('layout/theme/'.  $school->theme_name); ?>
        <?php }else{ ?>
            <?php $this->load->view('layout/theme/dodger-blue'); ?>
        <?php } ?>  

        <!-- CSS -->
        <link rel="stylesheet" href="<?php echo CSS_URL; ?>front1/bootstrap.min.css">
        <link rel="stylesheet" href="<?php echo CSS_URL; ?>front1/style.css">
        <link rel="stylesheet" href="<?php echo CSS_URL; ?>front1/responsive.css">
        <link href="<?php echo CSS_URL; ?>preloader.css" rel="stylesheet">
        
               

        
        <!-- HTML5 Shim and Respond.js IE8 support of HTML5 elements and media queries -->
        <!-- WARNING: Respond.js doesn't work if you view the page via file:// -->
        <!--[if lt IE 9]>
        <script src="https://oss.maxcdn.com/libs/html5shiv/3.7.0/html5shiv.js"></script>
        <script src="https://oss.maxcdn.com/libs/respond.js/1.4.2/respond.min.js"></script>
        <![endif]-->     

    </head>

    <body>
    <div class="wrapper">
        <div id="loader" class="loader green-color">
        	<div class="loader-container">
        		<div class='loader-icon'>
                        <?php if(isset($school->frontend_logo)){ ?>                            
                                <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $school->frontend_logo; ?>" alt=""  style="mix-blend-mode: color-burn;"/>
                            <?php }elseif(isset($school->logo)){ ?> 
                                <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $school->logo; ?>" alt=""  style="mix-blend-mode: color-burn;"/>
                            <?php }else{ ?>
                                 <img src="<?php echo IMG_URL; ?>default-front-logo.png" alt=""  />
                            <?php } ?>
                        </div>
                </div>
        </div>

        <?php //echo JS_URL; exit();?>
        
        <div class="myDiv">
            <!-- page content -->        
            <?php echo $content_for_layout; ?>
            <!-- /page content -->
            
            <!-- footer content -->
            <?php $this->load->view('layout/footer'); ?>   
            <!-- /footer content -->
        </div>
    </div>

        <!-- Scripts -->  
              
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/jquery-3.3.1.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/jquery-migrate-3.0.0.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/popper.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/bootstrap.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/jquery.mmenu.all.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/ace-responsive-menu.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/bootstrap-select.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/isotop.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/snackbar.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/simplebar.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/parallax.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/scrollto.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/jquery-scrolltofixed-min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/jquery.counterup.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/wow.min.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/progressbar.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/slider.js"></script>
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/timepicker.js"></script>
        <!-- Custom script for all pages --> 
        <script type="text/javascript" src="<?php echo JS_URL; ?>front1/script.js"></script>
        <script> $(window).on('load', function() {
            $('#loader').fadeOut('slow', function() { $(this).remove(); });
        });
        </script>
        
    </body>
</html>