<div class="row">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h3 class="head-title">
                    <i class="fa fa-file-text-o"></i>
                    <small><?php echo $this->lang->line('manage_result_card'); ?></small>
                </h3>
                <ul class="nav navbar-right panel_toolbox">
                    <li>
                        <a class="collapse-link"><i class="fa fa-chevron-up"></i></a>
                    </li>
                </ul>
                <div class="clearfix"></div>
            </div>

            <!-- Quick Links -->
            <div class="x_content quick-link no-print">
                <?php $this->load->view('quick-link-exam'); ?> 
            </div>      

            <!-- Filter Form -->
            <div class="x_content no-print"> 
                <?php echo form_open_multipart(site_url('exam/resultcard/all'), [
                    'name'  => 'resultcard', 
                    'id'    => 'resultcard', 
                    'class' => 'form-horizontal form-label-left'
                ]); ?>
                
                <div class="row">  
                    <?php $this->load->view('layout/school_list_filter'); ?> 

                    <!-- Academic Year -->
                    <div class="col-md-3 col-sm-3 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('academic_year'); ?> <span class="required">*</span></div>
                            <select class="form-control col-md-7 col-xs-12" 
                                    name="academic_year_id" 
                                    id="academic_year_id" 
                                    required 
                                    onchange="get_exams_by_academic_year(this.value);">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php foreach ($academic_years as $obj) { 
                                    $running = $obj->is_running ? ' ['.$this->lang->line('running_year').']' : ''; ?>
                                    <option value="<?php echo $obj->id; ?>" 
                                        <?php if(isset($academic_year_id) && $academic_year_id == $obj->id) echo 'selected'; ?>>
                                        <?php echo $obj->session_year . $running; ?>
                                    </option>
                                <?php } ?>
                            </select>
                        </div>
                    </div>

                    <!-- Exam -->
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('exam'); ?> <span class="required">*</span></div>
                            <select class="form-control col-md-7 col-xs-12" name="exam_id" id="exam_id" required>
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php if(isset($exams) && !empty($exams)) { 
                                    foreach($exams as $exam) { ?>
                                        <option value="<?php echo $exam->id; ?>" 
                                            <?php if(isset($exam_id) && $exam_id == $exam->id) echo 'selected="selected"'; ?>>
                                            <?php echo $exam->title; ?>
                                        </option>
                                <?php }} ?>
                            </select>
                        </div>
                    </div>


                    <!-- Class & Section -->
                    <?php if($this->session->userdata('role_id') != STUDENT ){ ?>    

                        <!-- Class -->
                        <div class="col-md-2 col-sm-2 col-xs-12">
                            <div class="item form-group"> 
                                <?php 
                                    $teacher_student_data = get_teacher_access_data('student'); 
                                    $guardian_class_data  = get_guardian_access_data('class'); 
                                ?>
                                <div><?php echo $this->lang->line('class'); ?> <span class="required">*</span></div>
                                <select class="form-control col-md-7 col-xs-12" 
                                        name="class_id" 
                                        id="class_id"  
                                        required 
                                        onchange="get_section_by_class(this.value,'');">
                                    <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                    <?php foreach ($classes as $obj) { 
                                        if($this->session->userdata('role_id') == TEACHER && !in_array($obj->id, $teacher_student_data)) continue; 
                                        if($this->session->userdata('role_id') == GUARDIAN && !in_array($obj->id, $guardian_class_data)) continue; ?>
                                        <option value="<?php echo $obj->id; ?>" 
                                            <?php if(isset($class_id) && $class_id == $obj->id) echo 'selected="selected"'; ?>>
                                            <?php echo $obj->name; ?>
                                        </option>
                                    <?php } ?>
                                </select>
                                <div class="help-block"><?php echo form_error('class_id'); ?></div>
                            </div>
                        </div>

                        <!-- Section -->
                        <div class="col-md-2 col-sm-2 col-xs-12">
                            <div class="item form-group"> 
                                <div><?php echo $this->lang->line('section'); ?></div>
                                <select class="form-control col-md-7 col-xs-12" name="section_id" id="section_id">                                
                                    <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                </select>
                                <div class="help-block"><?php echo form_error('section_id'); ?></div>
                            </div>
                        </div>                    
                    <?php } ?>    

                    <!-- Submit -->
                    <div class="col-md-1 col-sm-1 col-xs-12">
                        <div class="form-group"><br/>
                            <button id="send" type="submit" class="btn btn-success">
                                <?php echo $this->lang->line('find'); ?>
                            </button>
                        </div>
                    </div>
                </div>
                <?php echo form_close(); ?>
            </div>

            <!-- Student Result Loop -->
            <?php if (isset($students) && !empty($students)) { ?>
                <?php foreach ($students as $student) { ?>
                    
                    <!-- Student Result Card -->
                    <table width="90%" border="2" align="center" cellspacing="0" cellpadding="5" style="border-color:#FFD700; margin-bottom:30px;">
                        <tr>
                            <td colspan="5" align="center">
                                <table width="100%" border="0">
                                    <tr>
                                        <!-- Logo -->
                                        <td width="15%" rowspan="4" align="center">
                                            <?php 
                                            $logo = $school->logo ?? ($school->frontend_logo ?? $this->global_setting->brand_logo); 
                                            ?>
                                            <img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $logo; ?>" alt="School Logo" width="100%" style="margin-top:5%;" />
                                        </td>

                                        <!-- School Name -->
                                        <td align="center" width="70%">
                                            <h1>
                                                <?php
                                                $school_title = $school->school_name ?? '';
                                                for ($i = 0; $i < strlen($school_title); $i += 2) {
                                                    $color = ($i % 4 === 0) ? 'blue' : 'red';
                                                    echo '<font color="'.$color.'">'.substr($school_title, $i, 2).'</font>';
                                                }
                                                ?>
                                            </h1>
                                        </td>

                                        <!-- Student Photo -->
                                        <td width="15%" rowspan="4" align="center">
                                            <?php if (!empty($student->photo)) { ?>
                                                <img src="<?php echo UPLOAD_PATH; ?>/student-photo/<?php echo $student->photo; ?>" 
                                                     alt="Student Photo" style="width:100px; height:120px; object-fit:cover; border:1px solid #ccc;" />
                                            <?php } else { ?>
                                                <img src="<?php echo IMG_URL; ?>/default-user.png" 
                                                     alt="Default Photo" style="width:100px; height:120px; object-fit:cover; border:1px solid #ccc;" />
                                            <?php } ?>
                                        </td>
                                    </tr>

                                    <tr><td align="center"><?php echo $school->address ?? ''; ?></td></tr>
                                    <tr>
                                        <td align="center">
                                            <?php echo $this->lang->line('motto').': '; ?>
                                            <font color="red"><?php echo $school->motto ?? ''; ?></font>
                                        </td>
                                    </tr>
                                    <tr>
                                        <td align="center">
                                            <?php echo $this->lang->line('email').': '; ?>
                                            <font color="blue"><?php echo $school->email ?? ''; ?></font>, 
                                            <?php echo $this->lang->line('website').': '; ?>
                                            <font color="blue"><?php echo $school->website ?? ''; ?></font>
                                        </td>
                                    </tr>
                                    <tr bgcolor="<?php echo $this->global_setting->result_color; ?>">
                                        <td colspan="3" align="center" style="color:#000; font-weight:bold; padding:5px;">
                                            <h4><?php echo '<font color="blue">'.($ex->title ?? '').'</font>'; ?></h4>
                                        </td>
                                    </tr>
                                    </br>
                                    
                    <tr>
                <td colspan="6">
                    <table width="100%" border="1" cellpadding="5" cellspacing="0">
                         <!-- STUDENT BASIC INFO -->
                <tr>
                    <td width="15%" style="color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $this->lang->line('name'); ?>
                    </td>
                    <td width="25%" style="text-transform:uppercase; color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $student->name ?? ''; ?>
                    </td>
                    <td width="15%" style="color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $this->lang->line('admission_no'); ?>
                    </td>
                    <td width="15%" style="font-size:12px;">
                        &nbsp;&nbsp;<?php echo $student->admission_no ?? ''; ?>
                    </td>
                    <td width="10%">&nbsp;&nbsp;</td>
                    <td width="25%">&nbsp;&nbsp;</td>
                </tr>
                
                <tr>
                    <td width="15%" style="color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $this->lang->line('class'); ?>
                    </td>
                    <td width="25%">
    &nbsp;&nbsp;
    <?php 
        $selected_academic_year_id = $this->input->post('academic_year_id');
        $selected_class_id = $this->input->post('class_id');
        $selected_section_id = $this->input->post('section_id');

        if ($selected_academic_year_id && $selected_class_id && $selected_section_id) {
            echo get_student_class_and_section_all_students(
                $selected_academic_year_id, 
                $selected_class_id, 
                $selected_section_id
            );
        } else {
            echo "Please select class and section";
        }
    ?>
</td>


                    <td width="15%" style="color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $this->lang->line('gender'); ?>
                    </td>
                    <td width="15%" style="text-transform:capitalize; font-size:12px;">
                        &nbsp;&nbsp;<?php echo $student->gender ?? ''; ?>
                    </td>
                    <td width="10%" style="color:#000; font-size:12px;">
                        &nbsp;&nbsp;<?php echo "DOB"; ?>
                    </td>
                    <td width="25%" style="font-size:12px;">
                        &nbsp;&nbsp;<?php echo $student->dob ?? ''; ?>
                    </td>
                </tr>
                
                 <?php 
                    $final_result = get_final_result($school_id, $academic_year_id, $class_id, $student->section_id ?? 0, $student->id ?? 0);
                    $exam_details = get_exam_details($exam_id);
                    $exam_term_result = get_exam_term_result($school_id, $student->id ?? 0, $academic_year_id, $exam_id, $class_id, $student->section_id ?? 0);

                    $day_present = $exam_term_result->day_present ?? 0;
                    $next_term_begin = $exam_details['next_term_date'] ?? '';
                    $days_in_term = calculate_days_in_term($exam->term_begin ?? '', $exam->end_of_term_date ?? '');
                    $workingDays = (getWorkingDays($exam->term_begin ?? '', $exam->end_of_term_date ?? '') * 2) - ($exam->public_holiday ?? 0);
                    $days_absent = $workingDays - $day_present;

                    $attendanceSums = calculateAttendanceSum($academic_year_id, $exam_id, $student_id);
                    $selectedStudentId = $student_id;

                    foreach ($attendanceSums as $studentId => $attendanceSum) {
                        if ($studentId == $selectedStudentId) {
                            // Optional: display or use attendanceSum['present'] and ['absent']
                        }
                    }

                    $student_exam_results_details = get_exam_results_details($exam_id, $student_id);
                    
                    ?>

            <?php

                    if ($view_template === 'template0') {?>
               
                <!-- ATTENDANCE ROW FOR TEMPLATE0 -->
                <tr>
                    <td style="color:#000; font-size:12px;">&nbsp;&nbsp;<?php echo 'Days Open'; ?></td>
                    <td width="25%">
                        &nbsp;&nbsp;
                        <?php 
                            echo empty($student_exam_results_details['day_present']) 
                                ? ($attendanceSum['present'] ?? 0) + ($attendanceSum['absent'] ?? 0) 
                                : $workingDays;
                        ?>
                    </td>
                    <td style="color:#000; font-size:12px;">&nbsp;&nbsp;<?php echo 'Days Present'; ?></td>
                    <td width="25%">
                        &nbsp;&nbsp;
                        <?php 
                            echo empty($student_exam_results_details['day_present']) 
                                ? ($attendanceSum['present'] ?? 0) 
                                : $student_exam_results_details['day_present'];
                        ?>
                    </td>
                    <td style="color:#000; font-size:12px;">&nbsp;&nbsp;<?php echo 'Days Absent'; ?></td>
                    <td width="25%">
                        &nbsp;&nbsp;<?php echo $days_absent; ?>
                    </td>
                  </tr>
                   <tr>
                         <td style="color:#000;font-size:12px">&nbsp;&nbsp;<?php echo 'No. in Class'; ?></strong> </td>
                       <td width="25%">&nbsp;&nbsp;<?php echo get_total_students_in_class_and_section_for_exam($class_id, $section_id, $exam_id); ?> </td>
                       	
                      
						 <td style="color:#000"> <?php echo "&nbsp;&nbsp;" ?><?php echo 'Next Term Begins'; ?></td>
    					<td><?php echo "&nbsp;&nbsp;" ?><?php echo @$next_term_begin ; ?></td>
                        <td>&nbsp;&nbsp;</td>
                        <td>&nbsp;&nbsp;</td>
                          </tr>  
                   <?php } ?>
                
                 <?php if ($view_template != 'template0') { ?>
    <tr>
        <td style="color:#000; font-size:12px;">
            &nbsp;&nbsp;<?php echo 'No. in Class'; ?>
        </td>
        <td width="25%">
            &nbsp;&nbsp;<?php echo get_total_students_in_class_and_section_for_exam($class_id, $section_id, $exam_id); ?>
        </td>

        <?php
            $student_exam_results_details = get_exam_results_details($exam_id, $student_id);

            $mark = get_exam_wise_markt(
                $school_id,
                $academic_year_id,
                $exam->id,
                $class_id,
                $student->section_id ?? 0,
                $student->id ?? 0
            );

            $exam_total_mark = (
                $mark->written_mark + $mark->tutorial_mark + $mark->practical_mark +
                $mark->ex1_mark + $mark->ex2_mark + $mark->ex3_mark +
                $mark->ca4_mark + $mark->viva_mark + $mark->proj_mark
            );

            $obtain_total_mark = (
                $mark->written_obtain + $mark->tutorial_obtain + $mark->practical_obtain +
                $mark->ca4_obtain + $mark->ex1_obtain + $mark->ex2_obtain +
                $mark->ex3_obtain + $mark->proj_obtain + $mark->viva_obtain
            );

            $student_average = number_format($obtain_total_mark / ($mark->total_subject ?: 1), 2);

            $final_result = get_final_result(
                $school_id,
                $academic_year_id,
                $class_id,
                $student->section_id ?? 0,
                $student->id ?? 0
            );
        ?>

        <td style="color:#000; font-size:12px;">
            &nbsp;&nbsp;<?php echo 'Marks Obtained'; ?>
        </td>
        <td>
            &nbsp;&nbsp;<?php echo $student_exam_results_details['total_obtain_mark'] ?? ''; ?>
        </td>
        <td>			 <?php $rank = get_position_in_exam($school_id, $academic_year_id, $exam->id, $class_id, $student->section_id, $obtain_total_mark); ?>
                     <?php $class_position = get_student_position($school_id, $academic_year_id, $exam_id, $class_id, $student->id); ?>    
                    <?php $section_position = get_student_position($school_id, $academic_year_id,$exam_id, $class_id, $student->id, $student->section_id); ?> 
                    <?php $final_result = get_final_result($school_id, $academic_year_id, $class_id, $student->section_id, $student->id); ?> 
                  	<?php //echo "Position"; ?>
	
	<?php //echo @$rank ?>  
    </td>
    </tr>
                
     <?php } ?>            
                
                
      <tr>
    <!-- CLASS ATTENDANCE CALCULATED HERE -->
    <td style="color:#000; font-size:12px">&nbsp;&nbsp;<?php echo 'Days Open'; ?></td>
    <td width="25%">
        &nbsp;&nbsp;
        <?php 
        if (empty($student_exam_results_details['day_present'])) {
            echo (@$attendanceSum['present'] + @$attendanceSum['absent']);
        } else {
            echo @$workingDays;
        }
        ?>
    </td>

    <td style="color:#000;font-size:12px">&nbsp;&nbsp;<?php echo 'Marks Obtainable'; ?></td>
    <td>&nbsp;&nbsp;&nbsp;<?php echo $student_exam_results_details['total_mark'] ?? 0; ?></td>

    <!-- Begin Nursery SCHOOL GRADING SYSTEM -->
    <?php if ($view_template != 'template0') { ?>
        <td style="color:#000;font-size:12px">&nbsp;&nbsp;<?php echo 'Grade'; ?></td>
        <td>&nbsp;&nbsp;
            <?php
            $total_mark = $student_exam_results_details['total_mark'] ?? 0;
            $total_obtain_mark = $student_exam_results_details['total_obtain_mark'] ?? 0;

            // Safely calculate percentage to avoid division by zero
            if ($total_mark > 0) {
                $student_average = number_format(($total_obtain_mark / $total_mark) * 100, 2);

                if ($student_average >= 95) {
                    echo 'A+';
                } elseif ($student_average >= 89) {
                    echo 'A';
                } elseif ($student_average >= 80) {
                    echo 'B+';
                } elseif ($student_average >= 70) {
                    echo 'B';
                } elseif ($student_average >= 60) {
                    echo 'C';
                } elseif ($student_average >= 50) {
                    echo 'D';
                } elseif ($student_average < 50) {
                    echo 'E';
                } else {
                    echo '';
                }
            } else {
                echo 'N/A'; // or leave blank
            }
            ?>
        </td>
    <?php } ?>
</tr>
     
   <tr>
    <!-- ATTENDANCE CALCULATION HERE -->
    <td style="color:#000;font-size:12px">&nbsp;&nbsp;<?php echo 'Days Present'; ?></td>
    <td width="25%">
        &nbsp;
        <?php 
        if (empty($student_exam_results_details['day_present'])) {
            echo @$attendanceSum['present'] ?? 0;
        } else {
            echo $student_exam_results_details['day_present'];
        }
        ?>
    </td>

    <td style="color:#000;font-size:12px">&nbsp;&nbsp;<?php echo 'Student Average'; ?></td>
    <td>
        &nbsp;&nbsp;
        <?php
        $total_mark = $student_exam_results_details['total_mark'] ?? 0;
        $total_obtain_mark = $student_exam_results_details['total_obtain_mark'] ?? 0;

        if ($total_mark > 0) {
            echo number_format(($total_obtain_mark / $total_mark) * 100, 1) . ' %';
        } else {
            echo 'N/A';
        }
        ?>
    </td>

    <td>&nbsp;&nbsp;</td>
</tr>
  
     
    <tr>
   <td style="color:#000; font-size:12px">&nbsp;&nbsp;<?php echo 'Days Absent'; ?></strong>  </td>
	<!-- CLASS ATTENDANCE ABSENT CALCULATED HERE -->
    <td width="25%">
    &nbsp;&nbsp;<?php //echo $days_absent ;?><?php if (empty($student_exam_results_details['day_present'])) {
									  echo @$attendanceSum['absent'];
									} else {
									  echo (@$workingDays - $student_exam_results_details['day_present']);
									}; ?>
  </td>
     <td style="color:#000;font-size:12px" width="20%">&nbsp;&nbsp;
    <?php echo 'Class Average'; ?>
 </td>
   
<td> &nbsp;&nbsp; <?php 
	  $exam_lh = get_student_section_average($school_id, $academic_year_id, $exam->id, $class_id, $section_id, $student->id); 
   	// echo @number_format($exam_lh->section_average/$exam_lh->section_Maverage*100 ,1). '&nbsp;%' ; ?>
	 
	<?php
// Call the calculate_student_average function
$student_average = calculate_student_average($school_id, $exam_id, $class_id, $section_id);

// Display the student average only if the current academic year meets the conditions
if ($student_average > 0) {
    echo number_format($student_average, 1) . "%";
	
}
?>
  </td> 
<?php if ($view_template != 'template0') { ?>
                           
                      <td style="color:#309;font-size:12px">&nbsp; &nbsp;<strong>
    <?php echo $this->lang->line('remark'); ?>
</strong></td>
<td>
    &nbsp;&nbsp;
    <?php
        $total_mark = (float) @$student_exam_results_details['total_mark'];
        $obtain_mark = (float) @$student_exam_results_details['total_obtain_mark'];
        $student_average = 0;

        if ($total_mark > 0) {
            $student_average = number_format(($obtain_mark / $total_mark) * 100, 2);
        }

        if ($student_average >= 95) {
            echo 'Outstanding';
        } elseif ($student_average >= 89 && $student_average < 95) {
            echo 'Excellent';
        } elseif ($student_average >= 80 && $student_average < 89) {
            echo 'Very Good';
        } elseif ($student_average >= 70 && $student_average < 80) {
            echo 'Good';
        } elseif ($student_average >= 60 && $student_average < 70) {
            echo 'Credit';
        } elseif ($student_average >= 50 && $student_average < 60) {
            echo 'Pass';
        } elseif ($student_average < 50 && $total_mark > 0) {
            echo 'Fail';
        } else {
            echo '';
        }
    ?>
</td>

                                 
                                <?php } ?>  
                               
   
 </tr>  
               
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                
                        
                        </td>
                        </table>
                        
                                    
                              <br>      
                             </table>
                       <div>
                        <table>
                            
                            
                        </table>   
                           
                           
                       </div>     

                    <!-- Marks Table -->
                    <div class="x_content">
                        <table id="datatable-responsive" class="table table-striped_ table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                            <thead>
                                <tr>
                                    <th rowspan="2"><?php echo $this->lang->line('sl_no'); ?></th>
                                    <th rowspan="2" width="12%"><?php echo $this->lang->line('subject'); ?></th>
                                    <th colspan="2"><?php echo $this->lang->line('written'); ?></th>                                            
                                    <th colspan="2"><?php echo $this->lang->line('tutorial'); ?></th>                                            
                                    <th colspan="2"><?php echo $this->lang->line('practical'); ?></th>                                            
                                    <th colspan="2"><?php echo $this->lang->line('viva'); ?></th>                                            
                                    <th colspan="2"><?php echo $this->lang->line('total'); ?></th>                                            
                                    <th rowspan="2"><?php echo $this->lang->line('letter_grade'); ?></th>                                            
                                    <th rowspan="2"><?php echo $this->lang->line('grade_point'); ?></th>                                            
                                    <th rowspan="2"><?php echo $this->lang->line('lowest'); ?></th>                                            
                                    <th rowspan="2"><?php echo $this->lang->line('height'); ?></th>                                            
                                    <th rowspan="2"><?php echo $this->lang->line('position'); ?></th>                                            
                                </tr>
                                <tr>                           
                                    <th><?php echo $this->lang->line('mark'); ?></th>                                            
                                    <th><?php echo $this->lang->line('obtain'); ?></th>                                            
                                    <th><?php echo $this->lang->line('mark'); ?></th>                                            
                                    <th><?php echo $this->lang->line('obtain'); ?></th>                                            
                                    <th><?php echo $this->lang->line('mark'); ?></th>                                            
                                    <th><?php echo $this->lang->line('obtain'); ?></th>                                            
                                    <th><?php echo $this->lang->line('mark'); ?></th>                                            
                                    <th><?php echo $this->lang->line('obtain'); ?></th>                                            
                                    <th><?php echo $this->lang->line('mark'); ?></th>                                            
                                    <th><?php echo $this->lang->line('obtain'); ?></th> 
                                </tr>
                            </thead>
                            <tbody id="fn_mark"> 
                                <?php if (isset($exams) && !empty($exams)) { ?>
                                    <?php foreach ($exams as $ex) { ?>
                                        <tr style="background: #f9f9f9;">
                                            <th colspan="17"><?php echo $ex->title; ?></th>
                                        </tr>

                                        <?php
                                            $exam_subjects = get_subject_list($school_id, $academic_year_id, $ex->id, $class_id, $student->section_id, $student->id);
                                            $count = 1;
                                        ?>

                                        <?php if (!empty($exam_subjects)) { ?>
                                            <?php foreach ($exam_subjects as $obj) { ?>
                                                <?php 
                                                    $exam = get_exam_result($school_id, $ex->id, $student->id, $academic_year_id, $class_id, $student->section_id); 
                                                    if (@$exam->name == '') { continue; }
                                                    $lh       = get_lowet_height_mark($school_id, $academic_year_id, $ex->id, $class_id, $student->section_id, $obj->subject_id );
                                                    $position = get_position_in_subject($school_id, $academic_year_id, $ex->id, $class_id, $student->section_id, $obj->subject_id , $obj->obtain_total_mark); 
                                                ?>
                                                <tr>
                                                    <td><?php echo $count++; ?></td>
                                                    <td><?php echo ucfirst($obj->subject); ?></td>
                                                    <td><?php echo $obj->written_mark; ?></td>
                                                    <td><?php echo $obj->written_obtain; ?></td>
                                                    <td><?php echo $obj->tutorial_mark; ?></td>
                                                    <td><?php echo $obj->tutorial_obtain; ?></td>
                                                    <td><?php echo $obj->practical_mark; ?></td>
                                                    <td><?php echo $obj->practical_obtain; ?></td>
                                                    <td><?php echo $obj->viva_mark; ?></td>
                                                    <td><?php echo $obj->viva_obtain; ?></td>
                                                    <td><?php echo $obj->exam_total_mark; ?></td>
                                                    <td><?php echo $obj->obtain_total_mark; ?></td>
                                                    <td><?php echo $obj->name; ?></td>
                                                    <td><?php echo $obj->point; ?></td>                               
                                                    <td><?php echo $lh->lowest; ?></td>                               
                                                    <td><?php echo $lh->height; ?></td>                               
                                                    <td><?php echo $position; ?></td>                                
                                                </tr>
                                            <?php } ?>
                                        <?php } else { ?>
                                            <tr>
                                                <td colspan="17" align="center"><?php echo $this->lang->line('no_data_found'); ?></td>
                                            </tr>
                                        <?php } ?>   
                                    <?php } ?>
                                <?php } else { ?>
                                    <tr>
                                        <td colspan="17" align="center"><?php echo $this->lang->line('no_data_found'); ?></td>
                                    </tr>    
                                <?php } ?>            
                            </tbody>
                        </table> 
                    </div>

                    <!-- Summary / Final Result -->
                    <table class="table table-striped_ table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                        <thead>
                            <tr>
                                <th><?php echo $this->lang->line('total_subject'); ?></th>                                            
                                <th><?php echo $this->lang->line('total_mark'); ?></th>                                            
                                <th><?php echo $this->lang->line('obtain_mark'); ?></th>                                            
                                <th><?php echo $this->lang->line('percentage'); ?></th>                                            
                                <th><?php echo $this->lang->line('average_grade_point'); ?></th>                                            
                                <th><?php echo $this->lang->line('letter_grade'); ?></th>                                            
                                <th><?php echo $this->lang->line('status'); ?></th>                                            
                                <th><?php echo $this->lang->line('position_in_section'); ?></th>                                            
                                <th><?php echo $this->lang->line('position_in_class'); ?></th>                                            
                                <th><?php echo $this->lang->line('remark'); ?></th> 
                            </tr>
                        </thead>
                        <tbody>
                            <?php 
                                $class_position   = get_student_position($school_id, $academic_year_id, $class_id, $student->id);    
                                $section_position = get_student_position($school_id, $academic_year_id, $class_id, $student->id, $student->section_id); 
                                $final_result     = get_final_result($school_id, $academic_year_id, $class_id, $student->section_id, $student->id); 
                            ?> 
                            <tr>
                                <td><?php echo $final_result->total_subject ?? 0; ?></td> 
                                <td><?php echo $final_result->total_mark ?? 0; ?></td> 
                                <td><?php echo $final_result->total_obtain_mark ?? 0; ?></td> 
                                <td>
                                    <?php 
                                        echo (isset($final_result->total_mark) && $final_result->total_mark > 0) 
                                            ? number_format(($final_result->total_obtain_mark / $final_result->total_mark) * 100, 2) 
                                            : 0; 
                                    ?>%
                                </td> 
                                <td><?php echo $final_result->avg_grade_point ?? 0; ?></td> 
                                <td><?php echo $final_result->grade ?? 0; ?></td> 
                                <td><?php echo isset($final_result->result_status) ? $this->lang->line($final_result->result_status) : ''; ?></td> 
                                <td><?php echo $section_position; ?></td> 
                                <td><?php echo $class_position; ?></td> 
                                <td><?php echo $final_result->remark ?? '--'; ?></td>                         
                            </tr>
                        </tbody>
                    </table>

                    <!-- Signatures -->
                    <div class="rowt"><div class="col-lg-12">&nbsp;</div></div>
                    <div class="rowt">
                        <div class="col-xs-4 text-center signature">
                            <?php echo $this->lang->line('principal'); ?>
                        </div>
                <div class="col-xs-2 text-center">
                    &nbsp;
                </div>
                    <td width="1%">&nbsp;</td>
    </tr>
</table>
  
            
            
            <!-- BEGING FINAL CALCULATION -->
            <table class="table table-striped_ table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
               
                 <tbody> 
                 <?php if (isset($school_id)) { ?>
                            <?php 
                            @$mark = get_exam_wise_markt($school_id, $academic_year_id, $exam->id, $class_id, $student->section_id, $student->id ); 
                             @$exam_total_mark = $mark->written_mark+$mark->tutorial_mark+$mark->practical_mark+$mark->ex1_mark+$mark->ex2_mark+$mark->ex3_mark+$mark->ca4_mark+$mark->viva_mark+$mark->proj_mark;
                            @$obtain_total_mark = $mark->written_obtain+$mark->tutorial_obtain+$mark->practical_obtain+$mark->ca4_obtain+$mark->ex1_obtain+$mark->ex2_obtain+$mark->ex3_obtain+$mark->proj_obtain+$mark->viva_obtain; ?>
                  
                 </tbody>
            </table>
          
                       
          
         <!-- GRADING DETAILS  -->
          <?php if ($view_template != '') { ?>
             <table width="100%" border="0" cellpadding="2">
         <table width="100%" border="0">
  <tr>
  
    <td width="2%">&nbsp;</td>
      <?php if ($view_template != 'template0') { ?>   
    <td width="97%"> 
     <table width="100%" border="0">
                            <tr>
                             
                            <td width="80%" style="font-size:14px;">&nbsp;&nbsp;<?php echo $this->lang->line('grade_detail'); ?></td>
                            <td width="25%" align="left" style="font-size:14px;"><?php echo 'No. of Subjects'; ?>&nbsp;&nbsp;&nbsp; <?php echo @$student_exam_results_details['total_subject']; ?></td>
                            </tr>
               </table>
                 
               <table>            
                            <tr>
                            <td>&nbsp;&nbsp;</td>
                            
                            
                            
                            <?php if ($view_template == 'template1') { ?> 
                            <td width="100%" style="font-size:11px;"> &nbsp;&nbsp;<?php echo 
							"
							<strong>A+ </strong> &nbsp; (Excellent = 95-100), &nbsp; 
							 <strong>A</strong> &nbsp; (Excellent = 90-94), &nbsp; 
							 <strong>B+</strong> &nbsp; (Very Good  = 80-88),  &nbsp; 
							  <strong>B</strong> &nbsp; (Good  = 70-79),  &nbsp; 
							 <strong>C+</strong> &nbsp; (Fairly Good   = 60-69),  &nbsp;
							 <strong>C</strong> &nbsp; (Average   = 50-59), &nbsp; 
							 <strong>D</strong> &nbsp; (Fair   = 40-49), &nbsp; 
							 <strong>E</strong> &nbsp; (Poor  = 0-49) "
							; ?></td>
                         
                          <?php } ?>
                            
                           
						  
						  <?php if ($view_template == 'template2' ) { ?> 
                            <td width="100%" style="font-size:12px;"> &nbsp;&nbsp;<?php echo 
							"<strong>A+ </strong> &nbsp; ((W.A.E.L)  = 95-100), &nbsp; 
							 <strong>A</strong> &nbsp; ((W.A.E.L)  = 90-94), &nbsp; 
							 <strong>B+</strong> &nbsp; ((W.W.E.L)  = 80-88),  &nbsp; 
							  <strong>B</strong> &nbsp; ((W.W.E.L)  = 70-79),  &nbsp; 
							 <strong>C+</strong> &nbsp; ((W.B.E.L)   = 60-69),  &nbsp;
							 <strong>C</strong> &nbsp; ((W.B.E.L)   = 50-59), &nbsp; 
							 <strong>D</strong> &nbsp; ((S.N.E.S)  = 40-49), &nbsp; 
							 <strong>E</strong> &nbsp; ((S.N.E.S)  = 0-39) "
							;?></td>
                          
						  <?php } ?>
                          
                           </tr>
               </table>
          </td>
 <?php } ?>
 </tr>
 </table>
                  
           <!-- GRADING DETAILS  -->
            <?php  { ?>  
     <br>     
   <table width="99%" border="0">
   <tr>
   
   <?php if ($view_template == 'template1') { ?> 
  <td align="center">
 <h3><?php echo '<font color="blue">' . $exam->title. ' ' . 'PROGRESS REPORT' ; ?></h3>
</td>
   <?php } ?>

	 <?php if ($view_template == 'template2') { ?> 
  <td align="center">
 <h3><?php echo '<font color="blue">' . $exam->title. ' ' . 'ACADEMIC RATING' ; ?></h3>
</td>
   <?php } ?>
  </tr>
  
</table>  
         
 <table width="100%" border="0">
  <tr>
          <td width="100%" ><table width="100%" border="1" >
               	  
				  
				   <?php if ($view_template != 'template0') { ?>
				  
                 <tr>  
               		<td width="1%" bgcolor="#90BBE9"> <?php echo '<font color="black">' . "S/No";  ?></td>
                    <td align="center" width="15%" bgcolor="#90BBE9" >&nbsp;&nbsp;<b><?php echo '<font color="black">' . "Subject"; ?></b></td>
                    <td align="center" width="30%" bgcolor="orange">&nbsp;&nbsp;<b><?php echo '<font color="black">' . "TERM FOCUS"; ?></b></td>
					 <td align="center" width="10%" bgcolor="yellow">&nbsp;&nbsp;<b><?php echo '<font color="black">' . "EVALUATION"; ?></b></td>
                   
                  </tr> 
				   <?php
                        $count = 1;
                        if (isset($subjects) && !empty($subjects)) { ?>
                            <?php foreach ($subjects_with_comment as $obj) { ?>
                            
				  
                  <tr  class="table table-striped">
                                    
				  <?php if (isset($class_id)) { ?>
                    <td bgcolor="#E3E3E3" align="center"><?php  echo $count++;  ?></td>
                
                 	<?php if (isset($obj->remark ) && !empty($obj->remark )) { ?>  
                 	
					<td bgcolor="#E3E3E3">&nbsp;&nbsp;<b><?php echo '<font color="blue">' . ucfirst($obj->subject); ?></b>	</td>
					  <!--<td width="">&nbsp;<?php echo "TERM FOCUS" ; ?></td>-->
				
                    <td width="40%">&nbsp;<?php echo $obj->remark ; ?></td>
					 <td align="center" width="25%" >&nbsp;&nbsp;
					 <?php if (isset($obj->rating) && ($obj->rating == "1" )) echo "Beyond Expectation";
						elseif (isset($obj->rating) && ($obj->rating == "2" )) echo "Yet to Attain";
						elseif (isset($obj->rating) && ($obj->rating == "3" )) echo "On Track";
						elseif (isset($obj->rating) && ($obj->rating == "4" )) echo "Satisfactory";	
						elseif (isset($obj->rating) && ($obj->rating == "5" )) echo "Work in Progress";
						
					?></td>
                  
					 
                    
                 	<?php } ?> 
                  	<?php } ?> 
                   <?php } ?> 
                                     
                  </tr>
                  <?php } ?> 
				  <?php } ?> 
				  
                </table>
                </td>
   
             <td>
			 
    <table width="100%" border="0">
          <tr>
            <td>&nbsp;</td>
          </tr>
     </table>
    </td>
    
  </tr>
</table>


 <br>     
   <table width="99%" border="0">
   <tr>
   
   <?php if ($view_template == 'template1') { ?> 
  <td align="center">
 <h3><?php echo '<font color="blue">'  . 'LEARNING / SOCIAL BEHAVIOURS' ; ?></h3>
</td>
   <?php } ?>

	 <?php if ($view_template == 'template2') { ?> 
  <td align="center">
 <h3><?php echo '<font color="blue">' . 'LEARNING / SOCIAL BEHAVIOURS' ; ?></h3>
</td>
   <?php } ?>
   <?php  $student_exam_results_details = get_exam_results_details($exam_id, $student_id); ?>
  </tr>
  
  
  
  
  
  
  <?php if ($view_template != 'template0') { ?> 
  <tr>
   <td width="28%"><table width="100%" border="1">
               <tr>
                    <td width="35%" style="font-size:14px;color:#039;font-weight:bolder;text-transform:uppercase;" bgcolor="<?php echo $this->global_setting->result_color ?>">&nbsp;&nbsp;<?php 
					echo 'LEARNING / SOCIAL BEHAVIOURS'; ?></td>
                    <td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="orange">&nbsp;&nbsp;<?php echo 'Occassionaly'; ?></td>
					<td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="yellow">&nbsp;&nbsp;<?php echo 'Frequently'; ?></td>
					<td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="green">&nbsp;&nbsp;<?php echo 'Always'; ?></td>
                 
				  </tr>
                 <tr>
                    <td align style="color:#039">&nbsp;&nbsp;<?php echo  'Follows School Rules'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['rules']) && ($student_exam_results_details['rules'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['rules']) && ($student_exam_results_details['rules'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['rules']) && ($student_exam_results_details['rules'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>

                  </tr>
                  <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Displays a positive attitude to learning'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['attitude']) && ($student_exam_results_details['attitude'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['attitude']) && ($student_exam_results_details['attitude'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['attitude']) && ($student_exam_results_details['attitude'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                 <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Perseverance in the area of challenge'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['perseverance']) && ($student_exam_results_details['perseverance'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['perseverance']) && ($student_exam_results_details['perseverance'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['perseverance']) && ($student_exam_results_details['perseverance'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
				 
				 <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Makes the best use of all learning time'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['learning']) && ($student_exam_results_details['learning'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['learning']) && ($student_exam_results_details['learning'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['learning']) && ($student_exam_results_details['learning'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
				  
				  <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Takes on active part in lessons '; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['lessons']) && ($student_exam_results_details['lessons'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['lessons']) && ($student_exam_results_details['lessons'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['lessons']) && ($student_exam_results_details['lessons'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                 <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Neatness '; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['neatness']) && ($student_exam_results_details['neatness'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['neatness']) && ($student_exam_results_details['neatness'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['neatness']) && ($student_exam_results_details['neatness'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                  
                </table>
                </td>
				
				
				<td width="1%">&nbsp;</td>
				
				
				
		 <td width="28%"><table width="100%" border="1">
		 
		 <tr>
                    <td width="35%" style="font-size:14px;color:#039;font-weight:bolder;text-transform:uppercase;" bgcolor="<?php echo $this->global_setting->result_color ?>">&nbsp;&nbsp;<?php 
					echo 'LEARNING / SOCIAL BEHAVIOURS'; ?></td>
                    <td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="orange">&nbsp;&nbsp;<?php echo 'Occassionaly'; ?></td>
					<td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="yellow">&nbsp;&nbsp;<?php echo 'Frequently'; ?></td>
					<td align="center" width="5%"  style="font-size:12px;color:#000;font-weight:bolder" bgcolor="green">&nbsp;&nbsp;<?php echo 'Always'; ?></td>
                 
				  </tr>
               <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Punctuality'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['punctuality']) && ($student_exam_results_details['punctuality'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['punctuality']) && ($student_exam_results_details['punctuality'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['punctuality']) && ($student_exam_results_details['punctuality'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Uses resources to help him/her work independently'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['independently']) && ($student_exam_results_details['independently'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['independently']) && ($student_exam_results_details['independently'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['independently']) && ($student_exam_results_details['independently'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                  <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Concentration'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['concentration']) && ($student_exam_results_details['concentration'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['concentration']) && ($student_exam_results_details['concentration'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['concentration']) && ($student_exam_results_details['concentration'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                 <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Positive relationship with peers'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['relationship']) && ($student_exam_results_details['relationship'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['relationship']) && ($student_exam_results_details['relationship'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['relationship']) && ($student_exam_results_details['relationship'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                  <tr>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Use of Magic words (please, excuse me, sorry, thank you and pardon me'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['magic_word']) && ($student_exam_results_details['magic_word'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['magic_word']) && ($student_exam_results_details['magic_word'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['magic_word']) && ($student_exam_results_details['magic_word'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                 
                 
                  <tr hidden>
                    <td style="color:#039">&nbsp;&nbsp;<?php 
					echo 'Discipline'; ?></td>
                    <td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['discipline']) && ($student_exam_results_details['discipline'] == "1" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['discipline']) && ($student_exam_results_details['discipline'] == "2" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
					<td align="center" width="25%">
						&nbsp;&nbsp;<?php echo ""; ?>&nbsp;
						<?php if (isset($student_exam_results_details['discipline']) && ($student_exam_results_details['discipline'] == "3" )) echo '<i class="fa fa-check-circle-o" style="color: green;"></i>'; ?>
					</td>
                  </tr>
                  
                </table>
                </td>
						
				
  </tr>
  
    <?php } ?>  
	
	
	
	
	
	
	
	
	
	
	
	
	
	
	


	
  
</table>  
     <?php } ?>     
   
         
            <!-- END SCALES -->
     <br>
     
     
        
      <!-- BEGIN TEACHERS REMARK -->
      
  <table width="100%" border="0">
  <tr>
     <td width="100%">
    <table width="100%" border="1">
      
        
  <tr>
    <td width="23%" style="font-size:40;color:#000"> <?php echo "&nbsp;&nbsp;" ?><?php echo 'Class Teacher'; ?></td>
    <td hidden width="75%" style="font-size:10"><?php echo "&nbsp;" ?>
   <?php if(isset($section_id) && $section_id != ''){ echo get_teacher_from_section($section_id, $school_id)->tname; }else{ echo get_teacher_from_class($class_id, $school_id)->tname; } ?>
    </td> 
    
     <td style="font-size:10px"><?php echo "&nbsp;&nbsp;" ?><?php if(isset($student_exam_results_details['tname']) && $student_exam_results_details['tname'] != ''){ echo $student_exam_results_details['tname']; } else { echo get_teacher_from_class($class_id, $school_id)->tname; }; ?></td>
    
    
    
</tr>
<?php   $exam_term_result = get_exam_term_result($school_id, $student->id, $exam_id, $class_id, $student->section_id) ; ?>
  <tr>
    <td style="color:#000"> <?php echo "&nbsp;&nbsp;" ?><?php echo "Class Teacher's Remarks"; ?></td>
 
    <td><?php echo "&nbsp;&nbsp;" ?><?php echo 
    $student_exam_results_details['form_teacher_remark'];
    @$exam_term_result->form_teacher_remark; ?></td>
  </tr>
 <tr>
 
     <td style="color:#000"> <?php echo "&nbsp;&nbsp;" ?><?php echo "Head Teacher's Comment"; ?></td>
    <td style="color:#000" hidden> <?php echo "&nbsp;&nbsp;" ?><?php echo @$exam_term_result->principal_comment; ?></td>
         <td width="72%" style="font-size:12">&nbsp; <?php
                            
                           $exam_total_mark = $student_exam_results_details['total_mark'];
                            $obtain_total_mark = $student_exam_results_details['total_obtain_mark'];
                            $percentage_score42  = @number_format($obtain_total_mark/ $exam_total_mark*100,2);
								 
										if (@$percentage_score42 >= 80) {
											echo "An excellent performance. Keep it up. The sky is your springboard.";
										} 
										elseif (@$percentage_score42 >= 70 && @$percentage_score42 < 80) {
											echo " An outstanding performance. Keep up the good work.";
										} 
										elseif (@$percentage_score42 >= 60 && @$percenatge_score42 < 70) {
											echo "A very good performance. Keep making good efforts. You can do better.";
										} 
										
										
											elseif (@$percentage_score42 >= 50 && @$percenatge_score42 < 60) {
											 echo  "You have everything needed to excel academically. Keep working hard. You can do it!";
										} 
										
										
										elseif (@$percentage_score42 >= 0 && @$percenatge_score42 < 50) {
											echo " You need to go an extra mile to achieve your goals.";
										} 
										
										else {
											echo '';
										}
	
	
	
	?></td>
 </tr>
  <tr>
  
  
      <td style="color:#000"> <?php echo "&nbsp;&nbsp;" ?><?php echo 'Next Term Begins'; ?></td>
    <td><?php echo "&nbsp;&nbsp;" ?><?php echo @$next_term_begin; ?></td>
    
     </tr>
</table></td>
    <td width="2%">&nbsp;</td>
    </tr>
</table>
      <!-- END REMARK -->
    <br>                        
 
  <table border="0" width="100%"
   <!-- BEGIN SIGNATURE -->
  <tr>
  	<td width="30%" style="font-size:12px" align="center"> 
	<?php
    $teacher = get_teacher_from_section($section_id, $school_id);
    $photo_url = get_teacher_photo_url($teacher->tsignature);
?>
<img src="<?php echo $photo_url; ?>" alt="<?php echo $teacher->tname; ?>" width="35%" /><br>
    &nbsp;&nbsp;&nbsp;&nbsp;<?php echo "Class Teacher's Signature"; ?>
</td>
            <td width="15%">&nbsp;</td> 
             <td width="15%">&nbsp;</td> 
            
         <td width="40%" align="center"><img src="<?php echo UPLOAD_PATH; ?>/logo/<?php echo $school->signature; ?>" width="25%" /><br>
                    <?php echo "Head Teacher's Signature"; ?>
              
            <!-- END SINATURE -->;</td>  
           
     
          </tr>
          
          
          <?php } ?>  
          </table>
    </td>
    </tr>
     </Table
     
     ><?php } ?> 
     
      
    
        <div style="float: none; padding-top: 20px;margin-top: 20px;">&nbsp;</div>
            <div class="page-break" style="page-break-after: always !important;"></div>
            <?php } ?>
            <!-- END FINAL CALCULATION -->
            
            <div class="row no-print">
                <div class="col-xs-12 text-right">
                    <button class="btn btn-default " onclick="window.print();"><i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?></button>
                </div>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 no-print">
                <div class="instructions"><strong><?php echo $this->lang->line('instruction'); ?>: </strong> <?php echo $this->lang->line('mark_sheet_instruction'); ?></div>
            </div>


            </div>
            
            
            
            </td>
                        </tr>
                    </table>
            
            
            <div style="float: none; padding-top: 20px;margin-top: 20px;">&nbsp;</div>
            <div class="page-break" style="page-break-after: always !important;"></div>
           
            <?php } ?>
            
            
            
            
            <div class="row no-print">
                <div class="col-xs-12 text-right">
                    <button class="btn btn-default " onclick="window.print();"><i class="fa fa-print"></i> <?php echo $this->lang->line('print'); ?></button>
                </div>
            </div>
            <div class="col-md-12 col-sm-12 col-xs-12 no-print">
                <div class="instructions"><strong><?php echo $this->lang->line('instruction'); ?>: </strong> <?php echo $this->lang->line('mark_sheet_instruction'); ?></div>
            </div>
        </div>
    </div>
</div>




<!-- Super admin js START  -->
 <script type="text/javascript">
        
    $("document").ready(function() {
         <?php if(isset($school_id) && !empty($school_id)   && $this->session->userdata('role_id') == SUPER_ADMIN){ ?>               
            $(".fn_school_id").trigger('change');
         <?php } ?>
    });
    
    $('.fn_school_id').on('change', function(){
      
        var school_id = $(this).val();
        var academic_year_id = '';
        var class_id = '';
        
        <?php if(isset($school_id) && !empty($school_id)){ ?>
            academic_year_id =  '<?php echo $academic_year_id; ?>';     
            class_id =  '<?php echo $class_id; ?>';           
         <?php } ?> 
           
        if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        }
       
       $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_academic_year_by_school'); ?>",
            data   : { school_id:school_id, academic_year_id:academic_year_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               { 
                    $('#academic_year_id').html(response);  
                    get_class_by_school(school_id,class_id); 
               }
            }
        });
    }); 

   function get_class_by_school(school_id, class_id){       
         
        $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_class_by_school'); ?>",
            data   : { school_id:school_id, class_id:class_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               {
                    $('#class_id').html(response); 
               }
            }
        }); 
   }  
   
   
   
   
   function get_exams_by_academic_year() {
    var academic_year_id = $('#academic_year_id').val();
    if (!academic_year_id) {
        toastr.error('<?php echo $this->lang->line("select_school"); ?>');
        return false;
    }

    $.ajax({
        type: "POST",
        url: "<?php echo site_url('ajax/get_exams_by_academic_year_published'); ?>",
        data: { academic_year_id: academic_year_id },
        async: false,
        success: function (response) {
            if (response) $('#exam_id').html(response);
        }
    });
}


   
  </script>
<!-- Super admin js end -->

 <script type="text/javascript">     
  
    <?php if(isset($class_id) && isset($section_id)){ ?>
        get_section_by_class('<?php echo $class_id; ?>', '<?php echo $section_id; ?>');
    <?php } ?>
    
    function get_section_by_class(class_id, section_id){       
       
        var school_id = $('.fn_school_id').val();     
             
        if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        } 
        
        $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_section_by_class'); ?>",
            data   : { school_id:school_id, class_id : class_id , section_id: section_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               {
                  $('#section_id').html(response);
               }
            }
        });         
    } 
  $("#resultcard").validate(); 
</script>
<style>
.table>thead>tr>th,.table>tbody>tr>td {
    padding: 2px;
}
</style>