<?php

defined('BASEPATH') OR exit('No direct script access allowed');

class Resultcard extends MY_Controller {

    public $data = array();

    function __construct() {
        parent::__construct();
        $this->load->model('Resultcard_Model', 'resultcard', true);
        
        // check school subscription status
        if($this->session->userdata('role_id') != SUPER_ADMIN){                 
            if(!check_saas_status($this->session->userdata('school_id'), 'is_enable_exam_mark')){                        
                redirect('dashboard/index');
            }
        }
    }

    /*****************Function index**********************************
    * Load result card for a single student
    ***********************************************************/
    public function index() {

        check_permission(VIEW);

        if ($_POST) {

            if($this->session->userdata('role_id') == STUDENT){
                $student = get_user_by_role($this->session->userdata('role_id'), $this->session->userdata('id'));
                $school_id   = $student->school_id;
                $class_id    = $student->class_id;
                $section_id  = $student->section_id;
                $student_id  = $student->id;
            } else {
                $school_id   = $this->input->post('school_id');
                $class_id    = $this->input->post('class_id');
                $section_id  = $this->input->post('section_id');
                $student_id  = $this->input->post('student_id');

                $student        = $this->resultcard->get_single('students', array('id'=>$student_id));
                $student     = get_user_by_role(STUDENT, $student->user_id);
            }

            $school           = $this->resultcard->get_school_by_id($school_id);
            $academic_year_id = $this->input->post('academic_year_id');
            $exam_id          = $this->input->post('exam_id'); // ✅ get selected exam

            // fetch only the selected exam
            $this->data['exams'] = array();
            if (!empty($exam_id)) {
                $this->data['exams'] = $this->resultcard->get_list(
                    'exams',
                    array(
                        'id'              => $exam_id,
                        'school_id'       => $school_id,
                        'status'          => 1,
                        'academic_year_id'=> $academic_year_id
                    ),
                    '', '', '', 'id', 'ASC'
                );
            }

            $this->data['school']          = $school;
            $this->data['school_id']       = $school_id;
            $this->data['academic_year_id']= $academic_year_id;
            $this->data['exam_id']         = $exam_id;
            $this->data['student']         = $student;
            $this->data['class_id']        = $class_id;
            $this->data['section_id']      = $section_id;
            $this->data['student_id']      = $student_id;

            // ✅ pass exam_id into final result if supported by model
            $this->data['final_result']    = $this->resultcard->get_final_result(
                $school_id, $academic_year_id, $class_id, $section_id, $student_id, $exam_id
            );
        }

        $condition = array('status' => 1);        
        if($this->session->userdata('role_id') != SUPER_ADMIN){ 
            $condition['school_id']       = $this->session->userdata('school_id');            
            $this->data['classes']        = $this->resultcard->get_list('classes', $condition, '','', '', 'id', 'ASC');
            $this->data['academic_years'] = $this->resultcard->get_list('academic_years', $condition, '', '', '', 'id', 'ASC');
        }

        $this->layout->title($this->lang->line('manage_result_card') . ' | ' . SMS);
        $this->layout->view('result_card/index', $this->data);
    }
    
    /*****************Function all**********************************
    * Load result cards for all students in a class/section
    ***********************************************************/
    public function all() {

        check_permission(VIEW);

        if ($_POST) {

            $school_id = $this->input->post('school_id');
            $class_id  = $this->input->post('class_id');
            $section_id= $this->input->post('section_id');

            if($this->session->userdata('role_id') == STUDENT ){
                $class_id   = $this->session->userdata('class_id');
                $section_id = $this->session->userdata('section_id');
            }

            $school           = $this->resultcard->get_school_by_id($school_id);
            $academic_year_id = $this->input->post('academic_year_id');
            $exam_id          = $this->input->post('exam_id'); // ✅ get selected exam

            $students = $this->resultcard->get_student_list($school_id, $class_id, $section_id, $academic_year_id);

            // fetch only the selected exam
            $this->data['exams'] = array();
            if (!empty($exam_id)) {
                $this->data['exams'] = $this->resultcard->get_list(
                    'exams',
                    array(
                        'id'              => $exam_id,
                        'school_id'       => $school_id,
                        'status'          => 1,
                        'academic_year_id'=> $academic_year_id
                    ),
                    '', '', '', 'id', 'ASC'
                );
            }

            $this->data['school']          = $school;
            $this->data['school_id']       = $school_id;
            $this->data['academic_year_id']= $academic_year_id;
            $this->data['exam_id']         = $exam_id;
            $this->data['students']        = $students;
            $this->data['class_id']        = $class_id;
            $this->data['section_id']      = $section_id;
        }

        $condition = array('status' => 1);        
        if($this->session->userdata('role_id') != SUPER_ADMIN){ 
            $condition['school_id']       = $this->session->userdata('school_id');            
            $this->data['classes']        = $this->resultcard->get_list('classes', $condition, '','', '', 'id', 'ASC');
            $this->data['academic_years'] = $this->resultcard->get_list('academic_years', $condition, '', '', '', 'id', 'ASC');
        }

        $this->layout->title($this->lang->line('manage_all_result_card') . ' | ' . SMS);
        $this->layout->view('result_card/all', $this->data);
    }

}
