<?php

defined('BASEPATH') OR exit('No direct script access allowed');

/* * *****************Username.php**********************************
 * @product name    : Global Multi School Management System Express
 * @type            : Class
 * @class name      : Username
 * @description     : Reset users Username by System administrator.  
 * @author          : Codetroopers Team     
 * @url             : https://themeforest.net/user/codetroopers      
 * @support         : yousuf361@gmail.com 
 * @copyright       : Codetroopers Team     
 * ********************************************************** */

class Username extends MY_Controller {

    public $data = array();
    
    function __construct() {
        parent::__construct();
        $this->load->model('Administrator_Model', 'administrator', true);
        $this->data['roles'] = $this->administrator->get_list(
            'roles',
            array('status' => 1, 'is_super_admin' => 0),
            '', '', '', 'id', 'ASC'
        );
    }

    /*****************Function index**********************************
    * @type            : Function
    * @function name   : index
    * @description     : Load reset Username user interface                 
    *                    and reset user Username processing    
    * @param           : $id integer value
    * @return          : null 
    * ********************************************************** */ 
    public function index() {
        check_permission(EDIT);
       
        if ($this->input->post()) {
            $this->load->library('form_validation');
            $this->form_validation->set_error_delimiters(
                '<div class="error-message" style="color: red;">',
                '</div>'
            );

            $this->form_validation->set_rules(
                'role_id',
                $this->lang->line('user_type'),
                'trim|required'
            );
            
            if ($this->input->post('role_id') == STUDENT) {
                $this->form_validation->set_rules(
                    'class_id',
                    $this->lang->line('class'),
                    'trim|required'
                );  
            }
            
            $this->form_validation->set_rules(
                'user_id',
                $this->lang->line('user'),
                'trim|required'
            );

            $user_id  = $this->input->post('user_id');
            $username = $this->input->post('username');

            // ✅ use custom callback instead of is_unique
            $this->form_validation->set_rules(
                'username',
                $this->lang->line('username'),
                'trim|required|min_length[5]|max_length[80]|callback__check_unique_username['.$user_id.']'
            );
            
            if ($this->form_validation->run() === TRUE) {
                $data['username']    = $username;
                $data['modified_at'] = date('Y-m-d H:i:s');
                $data['modified_by'] = logged_in_user_id();
                
                $this->administrator->update('users', $data, ['id'=> $user_id]);
                success($this->lang->line('update_success'));
                
                $user = $this->administrator->get_single('users', ['id' => $user_id]);
                create_log('Has been updated username for user : '. $user->username);
                redirect('administrator/username/index');
            } else {
                error(validation_errors());
            }
        }
        
        $this->layout->title($this->lang->line('reset_username'). ' | ' . SMS);
        $this->layout->view('username/index', $this->data);
    }

    /**
     * ✅ Custom callback to check uniqueness except for current user
     */
    public function _check_unique_username($username, $user_id) {
        $existing = $this->administrator->get_single('users', ['username' => $username]);
        
        if ($existing && $existing->id != $user_id) {
            $this->form_validation->set_message(
                '_check_unique_username',
                $this->lang->line('already_exist') ?: 'The Username field must contain a unique value.'
            );
            return FALSE;
        }
        return TRUE;
    }
}
