<div class="row no-print">
    <div class="col-md-12 col-sm-12 col-xs-12">
        <div class="x_panel">
            <div class="x_title">
                <h3 class="head-title"><i class="fa fa-calculator"></i><small> <?php echo $this->lang->line('manage_due_receipt'); ?></small></h3>
                <ul class="nav navbar-right panel_toolbox">
                    <li><a class="collapse-link"><i class="fa fa-chevron-up"></i></a></li>                    
                </ul>
                <div class="clearfix"></div>
            </div>
                        
            <div class="x_content quick-link no-print">
                <?php $this->load->view('quick-link'); ?>  
            </div>
            
            
            <div class="x_content no-print"> 
                <?php echo form_open_multipart(site_url('accounting/receipt/duereceipt'), array('name' => 'duereceipt', 'id' => 'duereceipt', 'class' => 'form-horizontal form-label-left'), ''); ?>
                <div class="row">
                    <?php $teacher_access_data = get_teacher_access_data(); ?> 
                    <?php $guardian_access_data = get_guardian_access_data('class'); ?>
                    
                    <?php $this->load->view('layout/school_list_filter'); ?>

                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('class'); ?> <span class="required">*</span></div>
                            <select  class="form-control col-md-7 col-xs-12" name="class_id" id="class_id"  required="required" onchange="get_section_by_class(this.value, '');">
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                                <?php if(isset($classes) && !empty($classes)) { ?>
                                    <?php foreach ($classes as $obj) { ?>
                                    <?php
                                        if($this->session->userdata('role_id') == STUDENT){
                                            if ($obj->id != $this->session->userdata('class_id')){ continue; }
                                        }else if($this->session->userdata('role_id') == TEACHER){
                                          if (!in_array($obj->id, $teacher_access_data)) {continue; }
                                        }else if($this->session->userdata('role_id') == GUARDIAN){
                                           if (!in_array($obj->id, $guardian_access_data)) {continue; }
                                        } 
                                       ?>
                                    <option value="<?php echo $obj->id; ?>" <?php if(isset($class_id) && $class_id == $obj->id){ echo 'selected="selected"';} ?>><?php echo $obj->name; ?></option>
                                    <?php } ?>
                                <?php } ?>
                            </select>
                            <div class="help-block"><?php echo form_error('class_id'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('section'); ?> <span class="required">*</span></div>
                            <select  class="form-control col-md-7 col-xs-12" name="section_id" id="section_id" required onchange="get_student_by_section(this.value, '');">                                
                                <option value="">--<?php echo $this->lang->line('select'); ?>--</option>
                            </select>
                            <div class="help-block"><?php echo form_error('section_id'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-2 col-sm-2 col-xs-12">
                        <div class="item form-group"> 
                            <div><?php echo $this->lang->line('student'); ?></div>
                            <select  class="form-control col-md-7 col-xs-12"  name="student_id"  id="student_id">
                                <option value="">--<?php echo $this->lang->line('select_student'); ?>--</option> 
                            </select>
                            <div class="help-block"><?php echo form_error('student_id'); ?></div>
                        </div>
                    </div>
                    <div class="col-md-3 col-sm-3 col-xs-12">
                        <div class="form-group"><br/>
                            <button id="send" type="submit" class="btn btn-success"><?php echo $this->lang->line('find'); ?></button>
                        </div>
                    </div>

                </div>
                <?php echo form_close(); ?>
            </div>
                        
            <div class="x_content">               
                    
                 <div class="" data-example-id="togglable-tabs">
                    
                    <ul  class="nav nav-tabs bordered">                 
                        <li  class="active"><a href="#due_invoice" role="tab" data-toggle="tab" aria-expanded="false"><i class="fa fa-calculator"></i> <?php echo $this->lang->line('invoice_receipt'); ?></a></li>                          
                    </ul>
                    <br/>
                     <div class="tab-content">
                        <div  class="tab-pane fade in active" id="due_invoice" >
                            <div class="x_content">   
                               <table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
                                   <thead>
                                       <tr>
                                           <th><?php echo $this->lang->line('sl_no'); ?></th>
                                           <?php if($this->session->userdata('role_id') == SUPER_ADMIN){ ?>
                                           <th><?php echo $this->lang->line('school'); ?></th>
                                            <?php } ?>
                                           <th><?php echo $this->lang->line('invoice_number'); ?></th>
                                           <th><?php echo $this->lang->line('student'); ?>/<?php echo $this->lang->line('sale_to'); ?></th>
                                           <th><?php echo $this->lang->line('class'); ?></th>
                                           <th><?php echo $this->lang->line('status'); ?></th>
                                           <th><?php echo $this->lang->line('net_amount'); ?></th>
                                           <th><?php echo $this->lang->line('paid_amount'); ?></th>
                                           <th><?php echo $this->lang->line('due_amount'); ?></th>
                                           <th><?php echo $this->lang->line('action'); ?></th>                                            
                                       </tr>
                                   </thead>
                                   <tbody>   
                                       <?php $count = 1; if(isset($receipts) && !empty($receipts)){ ?>
                                           <?php foreach($receipts as $obj){ ?>
                                           <tr>
                                               <td><?php echo $count++; ?></td>
                                                <?php if($this->session->userdata('role_id') == SUPER_ADMIN){ ?>
                                                    <td><?php echo $obj->school_name; ?></td>
                                                <?php } ?>
                                               <td><?php echo $obj->custom_invoice_id; ?></td>
                                               <td>
                                               <?php $user = get_user_by_role($obj->role_id, $obj->user_id); ?>
                                                <?php
                
                                                if(!empty($user)){    
                                                ?>
                                                    <?php echo  $user->name; ?> [<?php echo  $user->role; ?>]<br>                
                                                    <?php
                                                    if($obj->role_id == STUDENT){
                                                        echo $this->lang->line('class').': '.$user->class_name.', '. $this->lang->line('section').': '.$user->section.', '. $this->lang->line('roll_no'). ':'. $user->roll_no;
                                                    }
                                                    ?>
                                                <?php } ?> 
                                               </td>
                                               <td><?php echo $obj->class_name; ?></td>
                                               <td><?php echo get_paid_status($obj->paid_status); ?></td>
                                               <td align="right"><?php echo @number_format($obj->net_amount,2); ?></td>
                                                <td class="green" align="right">
                                                   <?php 
                                                    $paid_amount = get_invoice_paid_amount($obj->id);
                                                    echo @number_format(($paid_amount->paid_amount), 2); 
                                                   ?>
                                               </td>
                                              <td class="red" align="right">
                                                   <?php 
                                                    $paid_amount = get_invoice_paid_amount($obj->id);
                                                    echo @number_format(($paid_amount->net_amount - $paid_amount->paid_amount) ,2); 
                                                   ?>
                                               </td>
                                                
                                               <td>
                                                  <a  onclick="get_due_receipt_modal(<?php echo $obj->inv_id; ?>);"  data-toggle="modal" data-target=".bs-receipt-modal-lg"  class="btn btn-success btn-xs"><i class="fa fa-eye"></i> <?php echo $this->lang->line('view'); ?> </a>
                                               </td>
                                           </tr>
                                           <?php } ?>
                                       <?php } ?>
                                   </tbody>
                               </table>
                           </div>
                        </div>
                 </div>
                </div>
            </div>
       
    </div>
</div>
</div>


<div class="modal fade bs-receipt-modal-lg" tabindex="-1" role="dialog" aria-hidden="true">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header  no-print">
          <button type="button" class="close" data-dismiss="modal"><span aria-hidden="true">×</span></button>
          <h4 class="modal-title"><?php echo $this->lang->line('detail_information'); ?></h4>
        </div>
        <div class="modal-body fn_receipt_data">            
        </div>       
      </div>
    </div>
</div>
<script type="text/javascript">
         
    function get_due_receipt_modal(inv_id){
         
        $('.fn_news_data').html('<p style="padding: 20px;"><p style="padding: 20px;text-align:center;"><img src="<?php echo IMG_URL; ?>loading.gif" /></p>');
        $.ajax({       
          type   : "POST",
          url    : "<?php echo site_url('accounting/receipt/get_single_due_receipt'); ?>",
          data   : {inv_id:inv_id},  
          success: function(response){                                                   
             if(response)
             {
                $('.fn_receipt_data').html(response);
             }
          }
       });
    }
</script>


<!-- Super admin js START  -->
<script type="text/javascript">

    $("document").ready(function () {
        <?php if (isset($school_id) && !empty($school_id)) { ?>
            $("#school_id").trigger('change');
        <?php } ?>
    });

    $('#school_id').on('change', function () {

        var school_id = $(this).val();        
        var class_id = '';
        
        <?php if(isset($school_id) && !empty($school_id)){ ?>
            class_id =  '<?php echo $class_id; ?>';
         <?php } ?> 

        if (!school_id) {
            toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        }
        
         $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_class_by_school'); ?>",
            data   : { school_id:school_id, class_id:class_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               { 
                   $('#class_id').html(response); 
               }
            }
        });
    });
    
    
    <?php if(isset($class_id) && isset($section_id)){ ?>
        get_section_by_class('<?php echo $class_id; ?>', '<?php echo $section_id; ?>');
    <?php } ?>
        
    function get_section_by_class(class_id, section_id){ 
        
        var school_id = $('#school_id').val();        
        
       if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        }
        
        $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_section_by_class'); ?>",
            data   : {school_id:school_id,  class_id : class_id , section_id: section_id},               
            async  : false,
            success: function(response){                                                   
               if(response)
               {
                  $('#section_id').html(response);
               }
            }
        }); 
    }
  

    <?php if(isset($class_id) && isset($section_id)){ ?>
        get_student_by_section('<?php echo $section_id; ?>', '<?php echo $student_id; ?>');
    <?php } ?>
    
    function get_student_by_section(section_id, student_id){       
        
        var school_id = $('#school_id').val();  
        if(!school_id){
           toastr.error('<?php echo $this->lang->line("select_school"); ?>');
           return false;
        } 
           
        $.ajax({       
            type   : "POST",
            url    : "<?php echo site_url('ajax/get_student_by_section'); ?>",
            data   : {school_id:school_id, section_id: section_id, student_id: student_id, is_all:true},               
            async  : false,
            success: function(response){                                                   
               if(response)
               {
                  $('#student_id').html(response);
               }
            }
        });         
    }
 
</script>
<!-- Super admin js end -->


<!-- datatable with buttons -->
 <script type="text/javascript">
    $(document).ready(function() {
      $('#datatable-responsive').DataTable( {
          dom: 'Bfrtip',
          iDisplayLength: 15,
          buttons: [
              'copyHtml5',
              'excelHtml5',
              'csvHtml5',
              'pdfHtml5',
              'pageLength'
          ],
          search: true,              
          responsive: true
      });
    });    
    
    $("#duereceipt").validate();
    
</script>