
<?php  
extract($_POST);
    function get_sub_subjects_list($subject_id) {
        $ci = & get_instance();
        $ci->db->select('S.*, T.name AS tNAME');
        $ci->db->from('subjects AS S');
        $ci->db->join('teachers AS T', 'T.id = S.teacher_id', 'left');
        $ci->db->where('relation_id', $subject_id);
        return $ci->db->get()->result();     
    }
?>


<table id="datatable-responsive" class="table table-striped table-bordered dt-responsive nowrap" cellspacing="0" width="100%">
    <thead>
        <tr>
            <th><?php echo $this->lang->line('sl_no'); ?></th> 
            <th><?php echo $this->lang->line('name'); ?></th>
            <th><?php echo $this->lang->line('subject_code'); ?></th> 
            <th><?php echo $this->lang->line('teacher'); ?></th>
            <th><?php echo $this->lang->line('action'); ?></th>                                            
        </tr>
    </thead>
    <tbody>   
        <?php $count = 1; 
        $subjects = get_sub_subjects_list($subject_id);
        if(isset($subjects) && !empty($subjects)){ ?>
            <?php 
                foreach($subjects as $obj){  

                if($this->session->userdata('role_id') == GUARDIAN){
                    if (!in_array($obj->class_id, $guardian_class_data)) {continue; }
                }elseif($this->session->userdata('role_id') == STUDENT){
                    if ($obj->class_id != $this->session->userdata('class_id')){ continue; }
                }
            ?>
            <tr>
                <td><?php echo $count++; ?></td> 
                <td><?php echo $obj->name; ?></td>
                <td><?php echo $obj->code; ?></td>  
                <td><?= $obj->tNAME ?> </td>
                <td>
                    <?php if(has_permission(EDIT, 'academic', 'subject')){ ?>
                        <a href="<?php echo site_url('academic/subject/edit/'.$obj->id); ?>" class="btn btn-info btn-xs"><i class="fa fa-pencil-square-o"></i> <?php echo $this->lang->line('edit'); ?> </a>
                    <?php } ?> 
                    <?php if(has_permission(DELETE, 'academic', 'subject')){ ?>
                        <a href="<?php echo site_url('academic/subject/delete/'.$obj->id); ?>" onclick="javascript: return confirm('<?php echo $this->lang->line('confirm_alert'); ?>');" class="btn btn-danger btn-xs"><i class="fa fa-trash-o"></i> <?php echo $this->lang->line('delete'); ?> </a>
                    <?php } ?>
                </td>
            </tr>
            <?php } ?>
        <?php } ?>
    </tbody>
</table>